#ifndef IPHYSICALCYLINDER_H_
#define IPHYSICALCYLINDER_H_

#include "IPhysicalBody.h"
#include "../DataTypes/DataCylinder.h"
using namespace DataTypes;
namespace PhysicsEngine
{

class IPhysicalCylinder : public PhysicsEngine::IPhysicalBody
{
public:
	IPhysicalCylinder();
	IPhysicalCylinder(int objectid, float radius, float length, Vector3f position,Vector3f rotation, int materialid, float mass);
	virtual ~IPhysicalCylinder();
	float GetRadius();
	float GetLength();
	void SetRadius(float value);
	void SetLength(float value);
	DataBody *GetDataBody();
	virtual DataCylinder* GetDataCylinder()=0;
private:
	float radius;
	float length;
};

}

#endif /*IPHYSICALCYLINDER_H_*/
